Rem SortParagraphs.vbs
Rem An InDesign CS3 VBScript
Rem
Rem Sorts the paragraphs in the selection in alphabetical order.
Rem
Rem For more on InDesign scripting, see http://www.adobe.com/products/indesign/xml_scripting.html.
Rem Or visit the InDesign scripting forum at http://www.adobeforums.com.
Rem
Set myInDesign = CreateObject("InDesign.Application.CS3")
If myInDesign.documents.Count <> 0 Then
    If myInDesign.selection.Count > 0 Then
	Select Case TypeName(myInDesign.Selection.Item(1))
		Case "Text", "TextColumn", "TextFrame"
	            mySortParagraphs myInDesign
		Case Else
	            MsgBox ("Please select some text (or a text frame) try again.")
	End Select
    Else
        MsgBox ("Nothing is selected. Please select some text (or a text frame) try again.")
    End If
Else
    MsgBox ("No documents are open. Please open a document and try again.")
End If
Function mySortParagraphs(myInDesign)
    Set mySelection = myInDesign.selection.Item(1)
    If mySelection.Characters.Count <> 0 Then
        Set myParagraphs = mySelection.Paragraphs
    Else
        Set myParagraphs = mySelection.parentTextFrame.Paragraphs
    End If
    Rem If the last paragraph in the selection is the last paragraph of the story,
    Rem and if the last paragraph does not end in a carriage return character,
    Rem then add a carriage return character at the end of the last paragraph.
    If myParagraphs.Item(-1).Characters.Item(-1).Contents <> vbCr Then
        myParagraphs.Item(-1).insertionPoints.Item(-1).Contents = vbCr
        myCleanUp = True
    Else
        myCleanUp = False
    End If
    Rem Simple bubble sort
    Do
        myItemMoved = False
        myCounter = 1
        Do While myCounter < myParagraphs.Count
            If myParagraphs.Item(myCounter).Contents > myParagraphs.Item(myCounter + 1).Contents Then
                myParagraphs.Item(myCounter).Move idAfter, myParagraphs.Item(myCounter + 1)
                myItemMoved = True
            End If
            myCounter = myCounter + 1
        Loop
        myCounter = myEnd
        Do While myCounter > 1
            If myParagraphs.Item(myCounter).Contents < myParagraphs.Item(myCounter - 1).Contents Then
                myParagraphs.Item(myCounter).Move idBefore, myParagraphs.Item(myCounter - 1)
                myItemMoved = True
            End If
            myCounter = myCounter - 1
        Loop
        If myItemMoved = False Then
            Exit Do
        End If
    Loop
    Rem If we added a return at the end of the story, we should now
    Rem remove the extra return at the end of the story.
    If myCleanUp = True Then
        myParagraphs.Item(1).parentStory.Characters.Item(-1).Delete
    End If
End Function
